<?php
// Gera o QR como PNG em tempo real.
// Isso evita o problema do "qr.png sumir" (hosting limpando arquivo / falta de espaço).

require_once __DIR__ . '/../includes/bootstrap_api.php';

// Sempre PNG
header('Content-Type: image/png');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

// 1) tenta pegar de api/qrcode.json
$qrValue = null;
$jsonPath = __DIR__ . '/qrcode.json';
if (file_exists($jsonPath)) {
    $raw = @file_get_contents($jsonPath);
    $data = json_decode($raw, true);
    if (is_array($data) && !empty($data['qrcode'])) {
        $qrValue = trim((string)$data['qrcode']);
    }
}

// 2) fallback para o DB do QR
if (!$qrValue) {
    $dbPath = __DIR__ . '/maxrebrandscode_qrcode.db';
    if (file_exists($dbPath)) {
        try {
            $db = new SQLite3($dbPath);
            $db->busyTimeout(3000);
            $res = $db->query("SELECT qrcode FROM qrcode WHERE id=1");
            if ($res) {
                $row = $res->fetchArray(SQLITE3_ASSOC);
                if (!empty($row['qrcode'])) {
                    $qrValue = trim((string)$row['qrcode']);
                }
            }
            $db->close();
        } catch (Exception $e) {
            // ignora
        }
    }
}

// 3) default
if (!$qrValue) {
    $qrValue = 'https://wa.me/5571983834846';
}

// Tenta gerar com a lib local (mais confiável do que depender de serviços externos)
try {
    require_once __DIR__ . '/../qrlib.php';
    if (class_exists('QRcode')) {
        // Saída direta em STDOUT
        QRcode::png($qrValue, false, QR_ECLEVEL_L, 6, 2);
        exit;
    }
} catch (Exception $e) {
    // fallback abaixo
}

// Fallback final: redireciona para um gerador externo
$url = 'https://image-charts.com/chart?chs=500x500&cht=qr&chl=' . urlencode($qrValue);
header('Location: ' . $url, true, 302);
exit;
