<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Banner TV - Ajuste Final Posicao Selo</title>
    <style>
        /* Reset básico */
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            width: 100vw;
            display: flex;
            justify-content: center;
            align-items: flex-end; 
            background: #000;
            font-family: Arial, sans-serif;
            overflow: hidden;
        }

        /* --- BACKGROUND FULL SCREEN --- */
        #content-poster {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
            z-index: -2;
            transition: opacity 0.8s ease-in-out, transform 10s linear;
            opacity: 0;
            transform: scale(1.1); 
        }
        
        #bg-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            /* Gradiente escuro para leitura */
            background: radial-gradient(circle at top right, rgba(0,0,0,0) 0%, rgba(0,0,0,0.4) 50%, rgba(0,0,0,0.9) 100%);
            z-index: -1;
        }

        /* --- CONTAINER PRINCIPAL --- */
        #content-container {
            position: relative;
            width: 90%;
            max-width: 1600px;
            height: auto;
            margin-bottom: 5vh;
            z-index: 1;
        }

        #start-3d-midia {
            position: absolute;
            top: -5vh; 
            right: 0;
            color: white;
            font-size: 1.5vw;
            font-weight: bold;
            text-shadow: 2px 3px 6px black, 0 0 15px white;
            opacity: 0.6;
        }

        /* CARD DE INFORMAÇÃO */
        .content-info-box {
            position: relative;
            width: 100%;
            display: flex;
            flex-direction: row;
            align-items: flex-start; /* Mantém alinhado no topo */
            gap: 2vw;
            color: #fff;
        }

        /* --- MUDANÇA 1: Wrapper da Capa puxado para a esquerda --- */
        .thumb-wrapper {
            position: relative;
            flex-shrink: 0;
            width: 20vw; 
            
            /* AQUI: Puxa a capa para a esquerda (margem negativa) */
            margin-left: -4vw; 
        }

        .content-thumbnail {
            width: 100%;
            height: auto;
            border-radius: 0.8vw;
            border: 3px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 10px 40px rgba(0,0,0,0.9);
            display: block;
        }

        /* --- MUDANÇA 2: Selo Filme/TV AUMENTADO e REPOSICIONADO --- */
        .content-type {
            position: absolute;
            
            top: auto;
            right: auto;

            /* --- AJUSTE DE POSIÇÃO AQUI --- */
            
            /* Mover para BAIXO: Use valor negativo para ficar abaixo da borda */
            /* Antes era: bottom: 10px; */
            bottom: 0px; 

            /* Mover para a DIREITA: Aumente a porcentagem */
            /* Antes era: left: 105%; */
            left: 110%; 
            
            /* ------------------------------ */

            /* AUMENTO DO TAMANHO (mantido do passo anterior) */
            padding: 0.8vw 1.5vw; 
            font-size: 1.8vw;     
            border-radius: 0.6vw; 
            
            background-color: #E50914;
            color: #fff;
            font-weight: bold;
            text-transform: uppercase;
            box-shadow: 0 2px 8px black;
            white-space: nowrap; /* Garante que o texto fique em uma linha só */
        }

        .content-text {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
            padding-top: 1vh; 
            text-shadow: 2px 2px 4px rgba(0,0,0,1);
        }

        .content-title {
            margin: 0 0 0.5vw 0;
            font-size: 4.5vw;
            font-weight: 900;
            text-transform: uppercase;
            line-height: 1;
        }

        .content-details {
            margin: 0 0 1.5vw 0;
            font-size: 1.3vw;
            color: #FFD700;
            font-weight: bold;
        }

        .content-description {
            margin: 0;
            font-size: 1.6vw;
            line-height: 1.3;
            max-height: 25vh;
            overflow: hidden;
            width: 90%;
            color: #ddd;
            display: -webkit-box;
            -webkit-line-clamp: 6; 
            -webkit-box-orient: vertical;
        }
    </style>
</head>
<body>

    <img id="content-poster" src="" alt="Background Full Screen">
    <div id="bg-overlay"></div>

    <div id="content-container">
        <div id="start-3d-midia">Start 3D Midia</div>

        <div id="content-info-box" class="content-info-box">
            <div class="thumb-wrapper">
                <img id="content-thumbnail" class="content-thumbnail" src="" alt="Capa Menor">
                <div id="content-type" class="content-type"></div>
            </div>

            <div class="content-text">
                <h1 id="content-title" class="content-title">Carregando...</h1>
                <p id="content-details" class="content-details"></p>
                <p id="content-description" class="content-description"></p>
            </div>
        </div>
    </div>

    <script>
        const apiKey = 'ec8237f367023fbadd38ab6a1596b40c';
        let currentIndex = 0;
        let contentIds = [];
        let intervalId = null;
        const transitionInterval = 10000;

        async function fetchContentIds() {
            try {
                const [popMovies, popTv, upMovies, topMovies, oscMovies] = await Promise.all([
                    fetch(`https://api.themoviedb.org/3/movie/popular?api_key=${apiKey}&language=pt-BR&release_date.gte=2012`),
                    fetch(`https://api.themoviedb.org/3/tv/popular?api_key=${apiKey}&language=pt-BR&first_air_date.gte=2012`),
                    fetch(`https://api.themoviedb.org/3/movie/upcoming?api_key=${apiKey}&language=pt-BR&region=BR`),
                    fetch(`https://api.themoviedb.org/3/movie/top_rated?api_key=${apiKey}&language=pt-BR&release_date.gte=2012`),
                    fetch(`https://api.themoviedb.org/3/movie/now_playing?api_key=${apiKey}&language=pt-BR&region=BR`)
                ]);

                const data = await Promise.all([popMovies.json(), popTv.json(), upMovies.json(), topMovies.json(), oscMovies.json()]);
                
                contentIds = [
                    ...data[0].results.map(m => ({ id: m.id, type: 'movie' })),
                    ...data[1].results.map(t => ({ id: t.id, type: 'tv' })),
                    ...data[2].results.map(m => ({ id: m.id, type: 'movie' })),
                    ...data[3].results.map(m => ({ id: m.id, type: 'movie' })),
                    ...data[4].results.map(m => ({ id: m.id, type: 'movie' }))
                ];
            } catch (error) { console.error(error); }
        }

        function preloadNextImage() {
            if (contentIds.length === 0) return;

            const nextIndex = (currentIndex + 1) % contentIds.length;
            const { id, type } = contentIds[nextIndex];

            fetch(`https://api.themoviedb.org/3/${type}/${id}?api_key=${apiKey}&language=pt-BR`)
                .then(res => res.json())
                .then(data => {
                    const nextImg = new Image();
                    nextImg.onload = () => {
                        const poster = document.getElementById('content-poster');
                        poster.style.opacity = 0;
                        poster.style.transform = "scale(1.1)"; 

                        setTimeout(() => {
                            poster.src = nextImg.src;
                            poster.style.opacity = 1;
                            poster.style.transform = "scale(1.0)"; 
                        }, 500);

                        updateContentInfo(data, type);
                    };
                    nextImg.src = `https://image.tmdb.org/t/p/original${data.backdrop_path}`;
                });
        }

        function updateContentInfo(data, type) {
            const date = data.release_date || data.first_air_date;
            const year = date ? new Date(date).getFullYear() : '';
            const title = `${data.title || data.name}${year ? ' (' + year + ')' : ''}`;
            const genres = data.genres ? data.genres.map(g => g.name).slice(0, 3).join(', ') : ''; 
            
            let duration = '';
            if (type === 'movie' && data.runtime) duration = `${data.runtime} min`;
            else if (type === 'tv' && data.episode_run_time?.length) duration = `${data.episode_run_time[0]} min/ep`;

            const desc = data.overview || 'Sinopse indisponível.';
            
            document.getElementById('content-type').textContent = type === 'movie' ? 'FILME' : 'SÉRIE';
            document.getElementById('content-title').textContent = title;
            document.getElementById('content-details').textContent = `${genres} ${duration ? '• ' + duration : ''}`;
            document.getElementById('content-description').textContent = desc;
            document.getElementById('content-thumbnail').src = `https://image.tmdb.org/t/p/w500${data.poster_path}`;

            clearInterval(intervalId);
            intervalId = setInterval(() => {
                currentIndex = (currentIndex + 1) % contentIds.length;
                preloadNextImage();
            }, transitionInterval);
        }

        window.onload = async () => {
            await fetchContentIds();
            preloadNextImage();
        };
    </script>
</body>
</html>